% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_variance_decomp}
\alias{get_variance_decomp}
\title{Get variance decomposition}
\usage{
get_variance_decomp(object, group = NULL)
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{group}{Optional; specific group to extract. If NULL, returns all groups}
}
\value{
A data frame with variance decomposition results
}
\description{
Get variance decomposition
}
\examples{
set.seed(456)
n_id <- 30
n_time <- 4
panel_data <- data.frame(
  id = factor(rep(1:n_id, each = n_time)),
  group = factor(rep(c("A", "B"), length.out = n_id * n_time)),
  x = rnorm(n_id * n_time)
)
panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
panel_data$d_x <- panel_data$x - panel_data$m_x
panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)

result <- xtvfreg(
  formula = y ~ 1,
  data = panel_data,
  group = "group",
  panel_id = "id",
  mean_vars = c("m_x", "d_x"),
  var_vars = "m_x",
  verbose = FALSE
)

# Get variance decomposition
get_variance_decomp(result)
}
