% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_definition.R
\name{set_attribute_definition_function}
\alias{set_attribute_definition_function}
\alias{set_attribute_definition_function.when}
\title{Set attribute definition function}
\usage{
set_attribute_definition_function(td, name, f)

\method{set_attribute_definition_function}{when}(td, name = NULL, f = NULL)
}
\arguments{
\item{td}{A \code{when} object.}

\item{name}{A string, attribute name.}

\item{f}{A function.}
}
\value{
A \code{when} object.
}
\description{
Each attribute is defined by a function that adds a column to a table based on
the parameter that contains the date or time. This function sets the definition
function for the attribute whose name is given.
}
\examples{

f <- function(table, values, ...) {
  table[['year']] <- 'Not defined'
  table
}

wd <- when() |>
  set_attribute_definition_function(name = "year", f)

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_attribute_definition_function}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
