% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/att_definition.R
\name{get_attribute_definition_function}
\alias{get_attribute_definition_function}
\alias{get_attribute_definition_function.when}
\title{Get attribute definition function}
\usage{
get_attribute_definition_function(td, name)

\method{get_attribute_definition_function}{when}(td, name = NULL)
}
\arguments{
\item{td}{A \code{when} object.}

\item{name}{A string, attribute name.}
}
\value{
A function.
}
\description{
Each attribute is defined by a function that adds a column to a table based on
the parameter that contains the date or time. This function returns the definition
function for the attribute whose name is given.
}
\examples{

f <- when() |>
  get_attribute_definition_function(name = "year")

}
\seealso{
Other dimension definition: 
\code{\link{define_characteristics}()},
\code{\link{define_instances}()},
\code{\link{get_day_part}()},
\code{\link{get_week_date_range}()},
\code{\link{select_date_levels}()},
\code{\link{select_day_level}()},
\code{\link{select_month_level}()},
\code{\link{select_quarter_level}()},
\code{\link{select_semester_level}()},
\code{\link{select_time_level}()},
\code{\link{select_week_level}()},
\code{\link{select_year_level}()},
\code{\link{set_attribute_definition_function}()},
\code{\link{set_day_part}()},
\code{\link{when}()}
}
\concept{dimension definition}
