% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dims.R
\name{TopOf}
\alias{TopOf}
\title{Top of}
\usage{
TopOf(
  x = NULL,
  height = NULL,
  pad = 0.01,
  min.ratio = 0.02,
  h.aln = NULL,
  v.scale = NULL,
  v.scale.proportional = FALSE
)
}
\arguments{
\item{x}{an object with dimension}

\item{height}{the height of the new object (when NULL, set to proportional to data)}

\item{pad}{padding between the target and current}

\item{min.ratio}{minimum ratio of dimensions when auto-scale}

\item{h.aln}{object for horizontal alignment (when NULL, set to x)}

\item{v.scale}{object for vertical scaling (when NULL, set to x)}

\item{v.scale.proportional}{when v.scale is provided, whether to make proportional to data}
}
\value{
a dimension generator on top of x
}
\description{
Generate dimension top of another object
}
\examples{
WHeatmap(matrix(rnorm(2000),nrow=40)) +
  WColorBarH(1:20, cmp=CMPar(), continuous=FALSE, TopOf())

}
