% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_accuracy.R
\name{efa}
\alias{efa}
\title{Estimate the forecast accuracy of a model on a time series}
\usage{
efa(model, h, type = c("normal", "minimum"), size = NULL, prop = NULL)
}
\arguments{
\item{model}{An object of class \code{utsf} with a model trained with a time
series.}

\item{h}{A positive integer. The forecasting horizon.}

\item{type}{A string. Possible values are \code{"normal"} (the default) and
\code{"minimum"}. See the vignette \link{utsf} for an explanation of both ways
of evaluating forecast accuracy.}

\item{size}{An integer. It is the size of the test set (how many of the last
observations of the time series are used as test set). It can only be used
when the type parameter is \code{"normal"}. By default, it is the length of the
forecasting horizon.}

\item{prop}{A numeric value in the range (0, 1). It is the proportion of the
time series used as test set. It can only be used when the type parameter is
\code{"normal"}.}
}
\value{
A list with four components: \item{\code{per_horizon}}{A matrix with the
estimated forecast accuracy per forecasting horizon using several
forecasting accuracy measures.}
\item{\code{global}}{The average estimated forecast accuracy for all the horizons. It is computed as the mean
of the different rows of the \code{per_horizon} component.}
\item{\code{test_sets}}{A matrix with the test sets used in the evaluation. Each
row of the matrix is a test set.} \item{\code{predictions}}{The predictions for the test sets.}
}
\description{
It uses an object of class \code{utsf} to asses the forecasting accuracy of its
associated model on its associated time series applying a rolling origin
evaluation.
}
\examples{
m <- create_model(UKgas, lags = 1:4, method = "rt")
efa(m, h = 4, type = "normal", size = 8)
}
