% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoCoprimary2Continuous.R
\name{twoCoprimary2Continuous}
\alias{twoCoprimary2Continuous}
\title{Unified Interface for Two Co-Primary Continuous Endpoints}
\usage{
twoCoprimary2Continuous(
  n1 = NULL,
  n2 = NULL,
  delta1,
  delta2,
  sd1,
  sd2,
  rho,
  power = NULL,
  r = NULL,
  alpha = 0.025,
  known_var = TRUE,
  nMC = 10000
)
}
\arguments{
\item{n1}{Sample size for group 1 (treatment group). If NULL, will be calculated.}

\item{n2}{Sample size for group 2 (control group). If NULL, will be calculated.}

\item{delta1}{Mean difference for the first endpoint}

\item{delta2}{Mean difference for the second endpoint}

\item{sd1}{Common standard deviation for the first endpoint}

\item{sd2}{Common standard deviation for the second endpoint}

\item{rho}{Common correlation between the two outcomes}

\item{power}{Target power (1 - beta). If NULL, will be calculated.}

\item{r}{Allocation ratio (n1/n2). Required when calculating sample size.}

\item{alpha}{One-sided significance level (typically 0.025 or 0.05)}

\item{known_var}{Logical indicating whether variance is known (TRUE) or
unknown (FALSE). Default is TRUE.}

\item{nMC}{Number of Monte Carlo simulations when known_var = FALSE.
Default is 10000.}
}
\value{
An object of class "twoCoprimary" containing either:
\itemize{
\item Power calculation results (when n1 and n2 are specified)
\item Sample size calculation results (when power and r are specified)
}
}
\description{
This function provides a unified interface for both power calculation and
sample size determination for two co-primary continuous endpoints. Depending
on which parameters are provided (sample sizes or power), the function
automatically determines whether to calculate power or sample size.
}
\details{
This function serves as a unified interface similar to \code{power.prop.test()}.
The function determines the operation mode based on which parameters are NULL:
\itemize{
\item If n1 and n2 are provided and power is NULL: calculates power
\item If power and r are provided and n1/n2 are NULL: calculates sample size
}

Exactly one of \{(n1, n2), (power, r)\} must be NULL.
}
\examples{
# Calculate power given sample sizes
twoCoprimary2Continuous(
  n1 = 100, n2 = 100,
  delta1 = 0.5, delta2 = 0.5,
  sd1 = 1, sd2 = 1,
  rho = 0.3, alpha = 0.025,
  known_var = TRUE
)

# Calculate sample size given target power
twoCoprimary2Continuous(
  delta1 = 0.5, delta2 = 0.5,
  sd1 = 1, sd2 = 1,
  rho = 0.3, power = 0.8,
  r = 1, alpha = 0.025,
  known_var = TRUE
)

}
