% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ps.cont.R
\name{plot.ps.cont}
\alias{plot.ps.cont}
\title{Plot the `ps.cont` object.}
\usage{
\method{plot}{ps.cont}(x, plots = "optimize", subset = NULL, ...)
}
\arguments{
\item{x}{`ps.cont` object}

\item{plots}{An indicator of which type of plot is desired. The options are
* `"optimize"` A plot of the balance criteria as a function of the GBM
  iteration.
* `"es"` Plots of the standardized effect size of the pre-treatment
  variables before and after weighting}

\item{subset}{Used to restrict which of the `stop.method`s will be used
in the figure.}

\item{...}{Additional arguments.}
}
\value{
Returns diagnostic plots for `ps.cont` objects.
}
\description{
This function produces a collection of diagnostic plots for `ps.cont` objects.
}
\examples{
   \dontrun{plot(test.mod)}

}
\seealso{
[ps.cont]
}
