% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsvreq_methods.R, R/vreq_methods.R
\name{set_ts}
\alias{set_ts}
\alias{set_ts.default}
\alias{set_tsvr}
\alias{set_tsvr.default}
\alias{set_wts}
\alias{set_wts.default}
\alias{get_ts}
\alias{get_ts.default}
\alias{get_tsvr}
\alias{get_tsvr.default}
\alias{get_wts}
\alias{get_wts.default}
\alias{setget_methods}
\alias{set_com}
\alias{set_com.default}
\alias{set_comnull}
\alias{set_comnull.default}
\alias{set_vr}
\alias{set_vr.default}
\alias{get_com}
\alias{get_com.default}
\alias{get_comnull}
\alias{get_comnull.default}
\alias{get_vr}
\alias{get_vr.default}
\title{Set and get methods for classes in the \code{tsvr} package}
\usage{
set_ts(obj, newval)

\method{set_ts}{default}(obj, newval)

set_tsvr(obj, newval)

\method{set_tsvr}{default}(obj, newval)

set_wts(obj, newval)

\method{set_wts}{default}(obj, newval)

get_ts(obj)

\method{get_ts}{default}(obj)

get_tsvr(obj)

\method{get_tsvr}{default}(obj)

get_wts(obj)

\method{get_wts}{default}(obj)

set_com(obj, newval)

\method{set_com}{default}(obj, newval)

set_comnull(obj, newval)

\method{set_comnull}{default}(obj, newval)

set_vr(obj, newval)

\method{set_vr}{default}(obj, newval)

get_com(obj)

\method{get_com}{default}(obj)

get_comnull(obj)

\method{get_comnull}{default}(obj)

get_vr(obj)

\method{get_vr}{default}(obj)
}
\arguments{
\item{obj}{An object of one of the classes defined in the package}

\item{newval}{A newvalue of the slot in question, for the \code{set_*} methods}
}
\value{
\code{set_*} methods throw an error - setting of individual
slots is not allowed, as it breaks consistency with the other slots.
\code{get_*} just returns the value in question.
}
\description{
Set and get methods for classes in the \code{tsvr} package. There
are methods for each slot of each class, named \code{set_*} and
\code{get_*} for \code{*} the slot name. Below are listed function
specs for the generics and the default methods.
}
\details{
There are methods for S3 classes defined in the package. See 
documentation for the generator functions for these classes (which in 
all cases have the same name as the class) for lists of slots for each 
class.
}
\examples{
res<-vreq(com=2,comnull=1,vr=2)
get_com(res)

}
\seealso{
\code{\link{vreq}}
}
\author{
Daniel Reuman, \email{reuman@ku.edu}
}
