% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_client.R
\name{tremendous_client}
\alias{tremendous_client}
\title{R6 Class representing a new Tremendous API Client}
\description{
R6 Class representing a new Tremendous API Client

R6 Class representing a new Tremendous API Client
}
\details{
Called by \code{\link{trem_client_new}} to bundle API key and environment.
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{key}}{(character) an API key}

\item{\code{sandbox}}{(logical) tremClient for Sandbox environment (TRUE) or production (FALSE)?}

\item{\code{httpClient}}{for internal use}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{tremendous_client$new()}}
\item \href{#method-print}{\code{tremendous_client$print()}}
\item \href{#method-clone}{\code{tremendous_client$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{tremClient} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tremendous_client$new(
  api_key = NULL,
  sandbox = TRUE,
  curl_opts = list(useragent = trem_ua())
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{API key from
\href{https://developers.tremendous.com/}{tremendous.com}. Can either pass in
here as a character string or set for repeated use with
\code{\link{trem_set_api_key}}.}

\item{\code{sandbox}}{Logical: \code{TRUE} (default) and any API requests are performed
within the Tremendous sandbox environment, a free and fully-featured
environment for application developing and testing. \code{FALSE} and the API
requests are performed within the Tremendous production environment. \strong{This
will involve sending actual money, so be certain you wish to do this!}}

\item{\code{curl_opts}}{A named list of curl options for the API Client. Defaults to include
useragent info.`}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printing method for object of class 'tremClient'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tremendous_client$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{NA; printing function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{tremendous_client$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
