% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-score.R
\name{score}
\alias{score}
\alias{score_z}
\alias{score_mad}
\alias{score_t}
\alias{score_chisq}
\title{Score transformation}
\usage{
score_z(x, na.rm = getOption("transx.na.rm"))

score_mad(x, na.rm = getOption("transx.na.rm"))

score_t(x, na.rm = getOption("transx.na.rm"))

score_chisq(x, na.rm = getOption("transx.na.rm"))
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{na.rm}{\verb{[logical(1): getOption("transx.na.rm")]}

A value indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

These functions calculate the scores according to:
\itemize{
\item \code{score_z}: Normal(z) distribution
\item \code{score_mad}: Mean absolute deviation
\item \code{score_t}: t-distribution
\item \code{score_chi}: chi-distribution
}
}
\details{
Because function are known with different names:
\itemize{
\item \code{score_z} is identical to \code{std_mean}
\item \code{score_mad} is identical to \code{std_median}
}
}
\examples{

x <- seq(-3,3,0.5)
score_z(x)
score_mad(x)
score_t(x)

}
\seealso{
\code{\link[outliers]{scores}}
}
