% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{scale_range}
\alias{scale_range}
\alias{scale_minmax}
\alias{scale_unit_len}
\title{Rescale}
\usage{
scale_range(x, to, na.rm = getOption("transx.na.rm"))

scale_minmax(x, na.rm = getOption("transx.na.rm"))

scale_unit_len(x, na.rm = getOption("transx.na.rm"))
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{to}{\verb{[numeric(2): NULL]}

Values that will determine the output range.}

\item{na.rm}{\verb{[logical(1): getOption("transx.na.rm")]}

A value indicating whether NA values should be stripped before the computation proceeds.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
}
\details{
To rescale a range between an arbitrary set of values [a, b], the formula becomes:
}
\examples{
x <- c(10,5,1,-2)
scale_range(x, c(-1, 2))
scale_minmax(x)
}
