% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05-root-power.R
\name{pow_boxcox}
\alias{pow_boxcox}
\title{Box-Cox Transformations}
\usage{
pow_boxcox(x, lambda = NULL, lambda2 = NULL, ...)
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{lambda}{\verb{[numeric(1): NULL]}

Transformation exponent, \eqn{\lambda}.}

\item{lambda2}{\verb{[numeric(1): NULL]}

Transformation exponent, \eqn{\lambda_2}.}

\item{...}{Further arguments passed to \code{pow}.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
}
\examples{
set.seed(123)
x <- runif(10)
pow_boxcox(x, 3)
}
\references{
Box, G. E., & Cox, D. R. (1964). An analysis of transformations.
Journal of the Royal Statistical Society. Series B (Methodological), 211-252.
\url{https://www.jstor.org/stable/2984418}
}
