% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-outliers.R
\name{out_winsorise}
\alias{out_winsorise}
\alias{out_winsorize}
\title{Winsorize}
\usage{
out_winsorise(x, min = quantile(x, 0.05), max = quantile(x, 0.95))

out_winsorize(x, min = quantile(x, 0.05), max = quantile(x, 0.95))
}
\arguments{
\item{x}{\verb{[univariate vector]}

Univariate vector, numeric or ts object with only one dimension.}

\item{min}{\verb{[numeric(1): quantile(x, 0.05)]}

The lower bound, all values lower than this will be replaced by this value.}

\item{max}{\verb{[numeric(1): quantile(x, 0.95)]}

The upper bound, all values above than this will be replaced by this value.}
}
\value{
Returns a vector with the same class and attributes as the input vector.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

Replace extremely values that are defined by \code{min} and \code{max}.
}
\examples{
x <- c(1, 3, -1, 5, 10, 100)
out_winsorise(x)

}
\seealso{
\code{\link[DescTools]{Winsorize}}
}
