% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trait_fit_distributions.R
\name{trait_fit_distributions}
\alias{trait_fit_distributions}
\title{Fit trait distributions}
\usage{
trait_fit_distributions(filled_traits, distribution_type = "normal")
}
\arguments{
\item{filled_traits}{output from the trait_fill function.}

\item{distribution_type}{the type of statistical distribution to use.
Character or named list. Currently accepts "normal","lognormal", and "beta".}
}
\value{
a tibble containing fitted distribution parameters for each trait in each species for each plot.
}
\description{
Function to fit parametric distributions for each
species-by-trait combination at the finest scale of the
user-supplied hierarchy.
This function returns a tibble containing the fitted parameters.
}
\details{
The distributions can either be a single distribution type which is
used for all traits, or traits can be assigned specific distributions types
by supplying the function with a named vector of traits, e.g.
\verb{c(height = "normal", mass = "lognormal"))}.
}
\examples{
library(dplyr)
data(community)
data(trait)

filled_traits <- trait_fill(
  comm = community |>
    filter(PlotID \%in\% c("A", "B")),
  traits = trait,
  scale_hierarchy = c("Site", "PlotID"),
  taxon_col = "Taxon", value_col = "Value",
  trait_col = "Trait", abundance_col = "Cover"
)

fitted_distributions <- trait_fit_distributions(
  filled_traits = filled_traits,
  distribution_type = "normal"
)
}
