% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{randomizer}
\alias{randomizer}
\title{randomizer}
\format{
This data frame contains the following columns:
\describe{
  \item{\code{season}}{Season number}
  \item{\code{episode}}{Episode number}
  \item{\code{round}}{Stage of the tournament: Qualifier semi-final,
  Qualifier final, Round of 32, Round of 16, Quarterfinals, Semifinals,
  Final}
  \item{\code{challenge}}{Variable to help distinguish challenges within the
  same Coast & Round}
  \item{\code{coast}}{East or West}
  \item{\code{region}}{The region depends on how many chefs start the
  competition. If there are 16 chefs, then the region is left blank. If
  there are 32 chefs, then the regions are A or B.}
  \item{\code{randomizer1}}{First wheel of randomizer}
  \item{\code{randomizer2}}{Second wheel of randomizer}
  \item{\code{randomizer3}}{Third wheel of randomizer}
  \item{\code{randomizer4}}{Fourth wheel of randomizer}
  \item{\code{time}}{Length of challenge. Unit is minutes}
  \item{\code{randomizer5}}{Fifth wheel of randomizer}
}
}
\source{
\url{https://en.wikipedia.org/wiki/Tournament_of_Champions_(TV_series)}
}
\usage{
data(randomizer)
}
\description{
A dataset containing information about each challenge: protein, vegetables,
equipment, style, time
}
\examples{
library(tidyverse)
randomizer \%>\%
   group_by(season,episode,challenge,coast) \%>\%
   filter(round == "Semi-final")
}
\keyword{datasets}
