% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinyplot_add.R
\name{tinyplot_add}
\alias{tinyplot_add}
\alias{plt_add}
\title{Add new elements to the current \code{tinyplot}}
\usage{
tinyplot_add(...)

plt_add(...)
}
\arguments{
\item{...}{All named arguments override arguments from the previous calls.
Arguments not supplied to \link{tinyplot_add} remain unchanged from the previous
call.}
}
\value{
No return value, called for side effect of producing a plot.
}
\description{
This convenience function grabs the preceding \code{tinyplot} call and updates it
with any new arguments that have been explicitly provided by the user. It
then injects \code{add=TRUE} and evaluates the updated call, thereby drawing a new
layer on top of the existing plot. \code{plt_add()} is a shorthand alias for
\code{tinyplot_add()}.
}
\section{Limitations}{

\itemize{
\item \code{tinyplot_add()} works reliably only when adding to a plot originally
created using the \code{\link{tinyplot.formula}} method with a valid \code{data} argument.
We cannot guarantee correct behavior if the original plot was created with
the atomic \code{\link{tinyplot.default}} method, due to potential environment
mismatches. (An exception is when the original plot arguments---\code{x}, \code{y},
etc.---are located in the global environment.)
\item Automatic legends for the added elements will be turned off.
}
}

\examples{
tinyplot(Sepal.Width ~ Sepal.Length | Species,
  facet = ~Species,
  data = iris)

tinyplot_add(type = "lm") ## or : plt_add(type = "lm")

## Note: the previous function is equivalent to (but much more convenient
## than) re-writing the full call with the new type and `add=TRUE`:

# tinyplot(Sepal.Width ~ Sepal.Length | Species,
#          facet = ~Species,
#          data = iris,
#          type = "lm",
#          add = TRUE)

}
