% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R, R/tfm.R
\name{noise.ssm}
\alias{noise.ssm}
\alias{noise}
\alias{noise.tfm}
\title{Extract Noise Component from Transfer Function Model}
\usage{
\method{noise}{ssm}(mdl, diff = TRUE, exp = FALSE, ...)

noise(mdl, ...)

\method{noise}{tfm}(mdl, y = NULL, diff = TRUE, exp = FALSE, envir = parent.frame(), ...)
}
\arguments{
\item{mdl}{A \code{tfm} object.}

\item{diff}{Logical. If TRUE (default), returns differenced noise series
(stationary). If FALSE, returns noise in original scale.}

\item{exp}{Logical. If TRUE, applies exponential transformation (inverse
of log). Only relevant when \code{diff = FALSE} and Box-Cox transformation
was used (\code{bc = TRUE}).}

\item{...}{Additional arguments.}

\item{y}{Optional \code{ts} object for alternative output series.}

\item{envir}{Environment for evaluation. NULL uses calling environment.}
}
\value{
A \code{ts} object containing the noise series, computed as
  output minus all transfer function and regressor effects.
}
\description{
Computes the noise series (output minus fitted signal) from a transfer
function model.
}
\details{
The noise represents the component of the output not explained by the
transfer functions and exogenous regressors. When \code{diff = TRUE},
the differencing operator from the noise model is applied, resulting in
a stationary series suitable for ARMA modeling.
}
\seealso{
\code{\link{signal.tfm}}, \code{\link{residuals.tfm}}, \code{\link{tfm}}
}
