% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_lisht}
\alias{activation_lisht}
\title{Lisht}
\usage{
activation_lisht(x)
}
\arguments{
\item{x}{A `Tensor`. Must be one of the following types: `float16`, `float32`, `float64`.}
}
\value{
A `Tensor`. Has the same type as `x`.
}
\description{
LiSHT: Non-Parameteric Linearly Scaled Hyperbolic Tangent Activation Function.
}
\details{
Computes linearly scaled hyperbolic tangent (LiSHT): `x * tanh(x)`
See [LiSHT: Non-Parameteric Linearly Scaled Hyperbolic Tangent Activation Function for Neural Networks](https://arxiv.org/abs/1901.05894).
}
\examples{

\dontrun{
library(keras)
library(tfaddons)
model = keras_model_sequential() \%>\%
layer_conv_2d(filters = 10, kernel_size = c(3,3),input_shape = c(28,28,1),
              activation = activation_lisht)
}

}
