% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gomes.R
\name{gomes}
\alias{gomes}
\title{A Double Bootstrap Procedure for Choosing the Optimal Sample Fraction}
\usage{
gomes(data, B = 1000, epsilon = 0.995)
}
\arguments{
\item{data}{vector of sample data}

\item{B}{number of Bootstrap replications}

\item{epsilon}{gives the amount of the first resampling size \code{n1} by choosing \code{n1 = n^epsilon}. Default is set to \code{epsilon=0.995}}
}
\value{
\item{second.order.par }{gives an estimation of the second order parameter \code{rho}.}
\item{k0}{optimal number of upper order statistics, i.e. number of exceedances or data in the tail}
\item{threshold}{the corresponding threshold}
\item{tail.index}{the corresponding tail}
}
\description{
An Implementation of the procedure proposed in Gomes et al. (2012) and Caeiro et al. (2016) for selecting the optimal sample fraction in tail index estimation.
}
\details{
The Double Bootstrap procedure simulates the AMSE criterion of the Hill estimator using an auxiliary statistic. Minimizing this statistic gives a consistent estimator of the sample fraction \code{k/n} with \code{k} the optimal number of upper order statistics. This number, denoted \code{k0} here, is equivalent to the number of extreme values or, if you wish, the number of exceedances in the context of a POT-model like the generalized Pareto distribution. \code{k0} can then be associated with the unknown threshold \code{u} of the GPD by choosing \code{u} as the \code{n-k0}th upper order statistic. For more information see references.
}
\examples{
data(danish)
gomes(danish)
}
\references{
Gomes, M.I. and Figueiredo, F. and Neves, M.M. (2012). Adaptive estimation of heavy right tails: resampling-based methods in action. \emph{Extremes}, \bold{15}, 463--489.

Caeiro, F. and Gomes, I. (2016). Threshold selection in extreme value analysis. \emph{Extreme Value Modeling and Risk Analysis: Methods and Applications}, 69--86.
}
