% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parafac_functions.R
\name{eempf_rescaleBC}
\alias{eempf_rescaleBC}
\title{Rescale B and C modes of PARAFAC model}
\usage{
eempf_rescaleBC(pfmodel, newscale = "Fmax")
}
\arguments{
\item{pfmodel}{object of class parafac}

\item{newscale}{If (default) newscale = "Fmax", each component will be scaled so the maximum of each component is 1. It is also possible to set a desired root mean-square for each column of the rescaled mode. Can input a scalar or a vector with length equal to the number of factors for the given mode.}
}
\value{
object of class parafac
}
\description{
B and C modes (emission and excitation wavelengths) are rescaled to RMS of value newscale. This is compensated in A mode (sample loadings).
}
\examples{
data(pf_models)

new_pf <- eempf_rescaleBC(pf4[[1]])
}
\seealso{
\code{\link[multiway]{rescale}}
}
