#' 15 fluorescence samples from drEEM used for examples.
#'
#' @format eemlist
"eem_list"

#' 2 fluorescence samples from drEEM that were excluded as outliers from the PARAFAC model.
#'
#' @format eemlist
"eem_list_outliers"

#' PARAFAC model, see vignette, unconstrained
#'
#' @format list of parafacs
"pf1"

#' PARAFAC model, see vignette, non-negative constraints
#'
#' @format list of parafacs
"pf1n"

#' PARAFAC model, see vignette, non-negative constraints, normalised
#'
#' @format list of parafacs
"pf2"

#' PARAFAC model, see vignette, non-negative constraints, normalised, outliers removed
#'
#' @format list of parafacs
"pf3"

#' PARAFAC model, see vignette, non-negative constraints, normalised, outliers removed, high accuarcy
#'
#' @format list of parafacs
"pf4"

#' result from PARAFAC split-half analysis, periodic data split
#'
#' @format list of parafacs
"sh"

#' data.frame containing common EEM peaks with the wavelengths and possible deviations
#'
#' @format data.frame
"peaks"
