% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{geom_eemscatter}
\alias{geom_eemscatter}
\title{Mark EEM scatter bands}
\usage{
geom_eemscatter(scatter = rep(TRUE, 4), ...)
}
\arguments{
\item{scatter}{logical vector of size 4 stating the scatter bands to be marked. The order is Raman 1, Raman 2, Rayleigh 1, Rayleigh 2.}

\item{...}{additional arguments to be passed on to \code{\link[ggplot2]{geom_function}}}
}
\value{
a layer to a ggplot2
}
\description{
geom_eemscatter draws dashed lines at the locations where scatter is expected in EEMs from water samples.
}
\examples{
require(tidyr)

eem_list \%>\%
  eem_extract(eem_names((eem_list))[1], keep = TRUE) \%>\%
  ggeem() +
  geom_eemscatter() +
  coord_cartesian(xlim = c(250,455), ylim = c(290,578))
}
