% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_comp.R
\name{sample_comp}
\alias{sample_comp}
\title{Sample composition data from expected values}
\usage{
sample_comp(data, Nsamp, fleets, years, ESS = NULL, cpar = 1)
}
\arguments{
\item{data}{A data frame with informational columns followed by
columns of compositional data.
The informational columns must include columns labeled
'Yr' and 'FltSvy' and end with a column labeled 'Nsamp'.
Columns of compositional data should follow 'Nsamp'.
Rows of compositional data do not need to sum to one.}

\item{Nsamp}{*A numeric list of the same length as \code{fleets}.
Either single values or vectors of the same length as the number of
years can be passed through. Single values are repeated for all
years. If no fleet collected samples, keep the value to
\code{Nsamp=NULL}.}

\item{fleets}{*A vector of integers specifying which fleets to include.
The order of the fleets pertains to the input order of other arguments.
An entry of \code{fleets=NULL} leads to zero samples for any fleet.}

\item{years}{*A list the same length as \code{fleets} giving the years as
numeric vectors. If no fleet collected samples, keep the value to
\code{years=NULL}.}

\item{ESS}{The final effective sample size (ESS) associated with the
simulated data. The ESS is not used to generate the simulated data
but can be used as an input sample size in subsequent models that estimate
population parameters or status.
The default, \code{NULL}, leads to the true (internally calculated)
#' ESS being used, which is \code{Nsamp} for the multinomial case or given
by the formula under \code{cpar} for the Dirichlet case.
At least one value must be provided for each fleet or a vector of
year-specific values can be used for any given fleet.
The argument accepts a list with entries,
either a single integer or a vector of integers, for each fleet.}

\item{cpar}{A numeric value or vector the same length as
\code{fleets} controlling the variance of the Dirichlet
distribution used for sampling. A value of \code{1} leads to the
same standard deviation as a multinomial of the given \code{Nsamp},
\code{2} indicates twice, etc. Values greater than one indicate
overdispersion, and less underdispersion. \code{NULL} or \code{NA}
for a given fleet will lead to no dispersion.}
}
\value{
A data frame of observed composition data.
}
\description{
Apply the multinomial or Dirichlet distribution to sample
composition data, creating a data frame that mimics
observed composition data.
}
\details{
Sample size, i.e., 'Nsamp', is used as a measure of precision,
where higher sample sizes lead to simulated samples that more accurately
represent the truth provided in \code{data}.
}
\author{
Kelli Faye Johnson
}
