% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_o.R
\name{change_o}
\alias{change_o}
\title{Methods to include parameters in an SS3operating model}
\usage{
change_o(change_o_list, ctl_file_in = "control.ss_new",
  ctl_file_out = "om.ctl", par_name = NULL, par_int = NULL,
  verbose = FALSE)
}
\arguments{
\item{change_o_list}{*A list of named vectors. Names correspond to parameters
in the operating model and the vectors correspond to deviations.
Alternatively, \code{par_name} and \code{par_init} can be passed to this
function.}

\item{ctl_file_in}{A string providing the path to the input SS \code{.ctl} file.}

\item{ctl_file_out}{A string providing the path to the output SS control file. If the value is \code{NULL}, the file will not be written to the disk.}

\item{par_name}{*A character vector of parameter names to pass in. NULL unless
want to use instead of \code{change_o_list}.}

\item{par_int}{*A numeric vector of parameter initial values to pass in. NULL
unless want to use instead of \code{change_o_list}. Must have the same
length and be in the same order as \code{par_names}, as the names should
correspond with their initial values.}

\item{verbose}{When \code{TRUE} messages will be returned
from the function. Often useful for debugging. The default
is \code{FALSE}.}
}
\value{
The function creates modified versions of the  \code{.ctl} files. The
  function also returns \code{change_o_list} invisibly.
}
\description{
\code{change_o} takes an SS3 \code{.ctl}file
and implements parameter value changes that are NOT time varying.
\code{change_o} is specifically set up to work with an operating model
\code{.ctl} file.
}
\section{Which arguments to specifiy in case files}{

All function argument descriptions that start with an asterisk (*) will be passed
through the case files to \code{\link{run_ss3sim}}. If one of these arguments
is not specified in a case file, then a value of \code{NULL} will be passed,
which may or may not be an appropriate value. Other arguments will be ignored
if specified.
}

\section{Specifying the \code{change_o_list}}{


Parameters initial values will change according to the values passed to
\code{change_o_list}. Each parameter should have a single value specified.

Parameter names must be unique and match the full parameter name in the
\code{.ctl} file.
}

\section{Passing arguments to \code{change_o} through \code{\link{run_ss3sim}}}{

(1) create a case file with an arbitrary letter
not used elsewhere (anything but D, E, F, or R) and (2) include the line
\code{function_type; change_o} in your case file. For example, you might
want to use M for natural mortality, S for selectivity, or G for growth.
}

\seealso{
Other change functions: \code{\link{change_data}},
  \code{\link{change_em_binning}}, \code{\link{change_e}},
  \code{\link{change_f_par}}, \code{\link{change_f}},
  \code{\link{change_retro}}, \code{\link{change_tv}}
}
\author{
Kathryn Doering
}
\concept{change functions}
