% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.vector.data.R
\name{prepare.vector.data}
\alias{prepare.vector.data}
\title{Prepare vector data for further reflectance data sampling}
\usage{
prepare.vector.data(shapefile_name, label_field)
}
\arguments{
\item{shapefile_name}{shapefile name (should be within working directory, using absolute
paths were not tested)}

\item{label_field}{name of the field which contains class labels}
}
\value{
sf object with label (characters) and class (integer) variables, as well as geometry of each polygon,
ready to further processing by rgee.
}
\description{
The function takes shapefile with polygons of different surface classes (habitats, crops,
vegetation, etc.), and retrieves ready-for-sampling sf object.
}
\examples{
# Load example data
load(system.file("testdata/reflectance_test_data.RData", package = "spectralR"))

# Prepare vector data
sf_df <- prepare.vector.data(
  shapefile_name = system.file("extdata/test_shapefile.shp", package = "spectralR"),
  label_field = "veget_type")

head(sf_df)

}
