% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cundill.R
\name{n_glm}
\alias{n_glm}
\title{Calculate sample size for a group comparison via generalized linear models}
\usage{
n_glm(
  mean0,
  mean1,
  dispersion0,
  dispersion1,
  alpha,
  power,
  link_fun = function(mu) NULL,
  variance_fun = function(mu, dispersion) NULL,
  dmu_deta_fun = function(mu) NULL,
  q
)
}
\arguments{
\item{mean0}{Mean in control group}

\item{mean1}{Mean in treatment group}

\item{dispersion0}{Dispersion parameter in control group}

\item{dispersion1}{Dispersion parameter in treatment group.}

\item{alpha}{Type I error rate}

\item{power}{1 - Type II error rate}

\item{link_fun}{function object, the link function to create the
response \eqn{\eta}.}

\item{variance_fun}{function object, function for computing the
variance based on a mean and a dispersion parameter}

\item{dmu_deta_fun}{function object, derivative of the original
mean with respect to the link: \eqn{d\mu / d\eta}.}

\item{q}{Number between 0 and 1, the proportion of observations
allocated to the control group}
}
\value{
Total sample size (numeric)
}
\description{
Estimation of required sample size as given by Cundill & Alexander (2015).
}
\references{
Cundill, B., & Alexander, N. D. E. (2015). Sample size calculations
for skewed distributions. \emph{BMC Medical Research Methodology},
15(1), 1–9. https://doi.org/10.1186/s12874-015-0023-0
}
