% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{jqui_position}
\alias{jqui_position}
\title{Position an element relative to another}
\usage{
jqui_position(
  ui,
  my = "center",
  at = "center",
  of,
  collision = "flip",
  within = JS("$(window)")
)
}
\arguments{
\item{ui}{Which element to be positioned. Can be a string of
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} or a
\link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{https://api.jquery.com/Types/}{jQuery object}. Only the first
matching element will be used.}

\item{my}{String. Defines which position \strong{on the element being positioned}
to align with the target element: "horizontal vertical" alignment. A single
value such as "right" will be normalized to "right center", "top" will be
normalized to "center top" (following CSS convention). Acceptable
horizontal values: "left", "center", "right". Acceptable vertical values:
"top", "center", "bottom". Example: "left top" or "center center". Each
dimension can also contain offsets, in pixels or percent, e.g., "right+10
top-25\%". Percentage offsets are relative to the element being positioned.}

\item{at}{String. Defines which position \strong{on the target element} to align
the positioned element against: "horizontal vertical" alignment. See the
\code{my} option for full details on possible values. Percentage offsets are
relative to the target element.}

\item{of}{Which element to position against. Can be a string of
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} or a
\link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{https://api.jquery.com/Types/}{jQuery object}. Only the first
matching element will be used.}

\item{collision}{String. When the positioned element overflows the window in
some direction, move it to an alternative position. Similar to \code{my} and
\code{at}, this accepts a single value or a pair for horizontal/vertical, e.g.,
"flip", "fit", "fit flip", "fit none".
\itemize{
\item "flip": Flips the element to the opposite side of the target and the
collision detection is run again to see if it will fit. Whichever side
allows more of the element to be visible will be used.
\item "fit": Shift the element away from the edge of the window.
\item "flipfit": First applies the flip logic, placing the element on whichever
side allows more of the element to be visible. Then the fit logic is
applied to ensure as much of the element is visible as possible.
\item "none": Does not apply any collision detection.
}}

\item{within}{Element to position within, affecting collision detection. Can
be a string of
\href{https://api.jquery.com/category/selectors/}{jQuery_selector} or a
\link[htmlwidgets:JS]{JS()} wrapped javascript expression that returns a
\href{https://api.jquery.com/Types/}{jQuery object}. Only the first
matching element will be used.}
}
\description{
Wrapper of the jQuery UI \href{https://api.jqueryui.com/position/}{.position()}
method, allows you to position an element relative to the window, document,
another element, or the cursor/mouse, without worrying about offset parents.
}
