% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rating.R
\name{update_rating_input}
\alias{update_rating_input}
\title{Update rating}
\usage{
update_rating_input(session, input_id, label = NULL, value = NULL)
}
\arguments{
\item{session}{shiny object with session info}

\item{input_id}{rating input name}

\item{label}{character with updated label}

\item{value}{new rating value}
}
\description{
Change the value of a rating input on the client. Check
\code{rating_input} to learn more.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
library(shiny)
library(shiny.semantic)

ui <- shinyUI(
  semanticPage(
    rating_input("rate", "How do you like it?", max = 5,
                 icon = "heart", color = "yellow"),
    numeric_input("numeric_in", "", 0, min = 0, max = 5)
  )
)
server <- function(session, input, output) {
  observeEvent(input$numeric_in, {
    x <- input$numeric_in
    update_rating_input(session, "rate", value = x)
  }
  )
}
shinyApp(ui = ui, server = server)
}

}
