% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{permute_states}
\alias{permute_states}
\title{Permute the states of NHMM using Hungarian algorithm}
\usage{
permute_states(estimates, reference)
}
\arguments{
\item{estimates}{A list \eqn{\gamma} coefficients as in \code{model$gammas},
where \code{model} is an \code{nhmm} object.}

\item{reference}{Another list of \eqn{\gamma} coefficients for which to match
the \code{estimates}.}
}
\value{
Permuted version of \code{estimates}, with added attribute \code{permutation}
which contains the permutations used to obtain for example the new
\code{gamma_pi} as \code{estimates$gamma_pi[perm, , drop = FALSE]}.
}
\description{
This function finds the permutation (according to Hungarian algorithm)
of estimated model coefficients \eqn{\gamma} which best matches some
reference values. The main purpose is to permute the bootstrap samples of
model coefficients to match as closely as possible to the maximum likelihood
estimates obtained from the original data.
}
\details{
The cost matrix in Hungarian algorithm is based on the sum of L2 norms of
the differences of estimated and reference values of \eqn{\pi}, \eqn{A} and
\eqn{B}.

This function is mostly meant for internal usage within the bootstrap
methods of \code{seqHMM}.
}
