% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeme_helpers.R
\name{filter_crowd_data}
\alias{filter_crowd_data}
\title{Filter and Prepare Data for a Specific Crowd}
\usage{
filter_crowd_data(data, args, crwd, omitted_cols_list, kept_indep_cats_list)
}
\arguments{
\item{data}{Data frame being analyzed}

\item{args}{List of makeme function arguments}

\item{crwd}{Character string identifying the current crowd}

\item{omitted_cols_list}{Named list of omitted variables for each crowd}

\item{kept_indep_cats_list}{Named list of kept independent categories for each crowd}
}
\value{
List with subset data and variables for the crowd, or NULL if no data remains:
\itemize{
\item \code{subset_data}: Filtered data frame for the crowd
\item \code{dep_crwd}: Character vector of dependent variables for this crowd
\item \code{indep_crwd}: Character vector of independent variables for this crowd
}
}
\description{
Internal helper function that filters data for a specific crowd identifier,
applying variable exclusions and category filtering as needed.
}
\details{
Applies the following filtering steps:
\itemize{
\item Removes omitted variables based on hiding criteria
\item Filters rows to match crowd membership
\item Applies independent category filtering if enabled
\item Returns NULL and warns if no data remains after filtering
}
}
\keyword{internal}
