% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Z_identities.R
\name{Bayesian_Sampler}
\alias{Bayesian_Sampler}
\title{Bayesian Sampler Model}
\usage{
Bayesian_Sampler(
  a_and_b,
  b_and_not_a,
  a_and_not_b,
  not_a_and_not_b,
  beta,
  N,
  N2 = NULL,
  return = "mean",
  n_simulations = 1000
)
}
\arguments{
\item{a_and_b, b_and_not_a, a_and_not_b, not_a_and_not_b}{True probabilites for the conjuctions and disjunctions of A and B. Must add to 1.}

\item{beta}{Prior parameter.}

\item{N}{Number of samples drawn}

\item{N2}{Optional. Number of samples drawn for conjunctions and disjunctions. (called N' in the paper). If not given, it will default to N2=N. Must be equal or smaller than N.}

\item{return}{Optional. Either "mean", "variance" or "simulation". Defaults to "mean".}

\item{n_simulations}{Optional. if return="simulation", how many simulations per possible combination of A and B. Defaults to 1000.}
}
\value{
If return="mean" or return="variance", named list with predicted probabilities for every possible combination of A and B, or the expected variance of those predictions. If return="simulation", simulated predictions instead. Note that if return="simulation", the named list will contain vectors if the length of the true probabilities is 1; otherwise a matrix where each column is a queried probability and each row a simulation
}
\description{
As described in \insertCite{zhu2020BayesianSamplerGeneric}{samplr}. Vectors can be provided for each parameter, allowing multiple estimates at once.
}
\examples{
Bayesian_Sampler(
    a_and_b = c(.4, .25),
    b_and_not_a = c(.4,  .25),
    a_and_not_b = c(.1, .25),
    not_a_and_not_b = c(.1, .25),
    beta = 1,
    N <- c(10, 12),
    N2 <- c(10, 10)
)
Bayesian_Sampler(
   a_and_b = c(0.05, .85),
   b_and_not_a = c(.85,  0.05),
   a_and_not_b = c(.05, 0.05),
   not_a_and_not_b = c(0.05, 0.05),
   beta = 1,
   N = 5,
   return="simulation"
)$a
}
\references{
\insertAllCited{}
}
