% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-statevar.R
\name{plot_tradeoff}
\alias{plot_tradeoff}
\title{Tradeoff figure}
\usage{
plot_tradeoff(pm1, pm2, x1, x2, xlab, ylab, x1lab, x2lab)
}
\arguments{
\item{pm1}{Numeric or matrix. A vector of values for the first performance metric on the x-axis. Alternatively, provide a three column matrix corresponding
to the lower bound, central tendency, and upper bound.}

\item{pm2}{Numeric or matrix. A vector of values for the second performance metric on the y-axis (same length as pm1). Alternatively, provide a three column matrix corresponding
to the lower bound, central tendency, and upper bound.}

\item{x1}{Atomic, vector of values for the first grouping variable. Various levels are represented by colours. Same length as pm1.}

\item{x2}{Numeric, vector of values for the second grouping variable. Various levels are represented by shapes. Same length as pm1.}

\item{xlab}{Character, optional x-axis label}

\item{ylab}{Character, optional y-axis label}

\item{x1lab}{Character, optional label for the first grouping variable}

\item{x2lab}{Character, optional label for the second grouping variable}
}
\value{
ggplot object
}
\description{
Generates a tradeoff figure, a comparison between two performance metrics, across two variables which may represent
a population dynamics variable (e.g., productivity) or a management action (e.g., hatchery production levels or harvest strategy).
See example at \url{https://docs.salmonmse.com/articles/decision-table.html}
}
\seealso{
\code{\link[=plot_statevar_ts]{plot_statevar_ts()}} \code{\link[=plot_decision_table]{plot_decision_table()}}
}
