% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harvest_MMP.R
\name{get_F}
\alias{get_F}
\title{Calculate F from harvest rate}
\usage{
get_F(
  u = 0,
  K = 0,
  type = c("u", "catch"),
  M,
  N = 1,
  vul = 1,
  ret = 1,
  release_mort = 0,
  Fmax = 20
)
}
\arguments{
\item{u}{Harvest rate, between 0-1}

\item{K}{Catch, between 0-Inf}

\item{type}{Character, either \code{"catch"}, or \code{"u"}, whether to solve for catch or harvest rate, respectively}

\item{M}{Instantaneous natural mortality rate}

\item{N}{Abundance}

\item{vul}{Vulnerability}

\item{ret}{Retention rate}

\item{release_mort}{Release mortality as a proportion, between 0-1. Only relevant if \code{ret < 1}.}

\item{Fmax}{Maximum allowable value of F}
}
\value{
Numeric for the apical F
}
\description{
Solves for apical instantaneous fishing mortality rate (F), proportional to fishing effort, from harvest rate (total retained catch over total abundance).
The apical F can be greater than the realized F, if retention < 1.
}
\keyword{internal}
