% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stac-query.R
\name{stac}
\alias{stac}
\title{Endpoint functions}
\usage{
stac(base_url, force_version = NULL)
}
\arguments{
\item{base_url}{a \code{character} informing the base URL of a
STAC web service.}

\item{force_version}{a \code{character} providing the version of the STAC
used. If not provided, the rstac package will make requests to try to find
the version of STAC used. It is highly recommended that you inform the STAC
version you are using.}
}
\value{
A \code{rstac_query} object with the subclass \code{stac} containing all
request parameters to be provided to API service.
}
\description{
The \code{stac} function implements \verb{/stac} API
endpoint (>=0.8.0), and \code{/} for versions 0.9.0 or higher. It prepares
search field parameters to be provided to a STAC API web service. This
endpoint should return a STAC Catalog document containing all published data
catalogs.
}
\examples{
\dontrun{
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
   get_request()
}

}
\seealso{
\code{\link[=stac_search]{stac_search()}}, \code{\link[=collections]{collections()}},
\code{\link[=items]{items()}}, \code{\link[=get_request]{get_request()}},
\code{\link[=post_request]{post_request()}}
}
