% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queryables-query.R
\name{queryables}
\alias{queryables}
\title{Endpoint functions}
\usage{
queryables(q)
}
\arguments{
\item{q}{a \code{rstac_query} object expressing a STAC query criteria.}
}
\value{
A \code{rstac_query} object with the subclass \code{queryables} for \verb{/queryables}
endpoint.
}
\description{
The queryables endpoint allows the user to discover which
properties can be used in the filter extension.
This endpoint can be accessed from the catalog (\verb{/queryables})
or from a collection (\verb{/collections/\{collection_id\}/queryables}).
}
\examples{
\dontrun{
# Catalog's queryables
stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
  queryables() \%>\% get_request()

# Collection's queryables
stac("https://planetarycomputer.microsoft.com/api/stac/v1") \%>\%
  collections(collection_id = "sentinel-2-l2a") \%>\%
  queryables() \%>\%
  get_request()
}

}
\seealso{
\code{\link[=ext_filter]{ext_filter()}},  \code{\link[=conformance]{conformance()}}, \code{\link[=collections]{collections()}}
}
