% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kobo_data.R
\name{kobo_attachment_download}
\alias{kobo_attachment_download}
\title{Download submitted files associatted to KoboToolbox API asset}
\usage{
kobo_attachment_download(x, folder, progress, overwrite, n_retry)
}
\arguments{
\item{x}{the asset uid or the \code{kobo_asset} object.}

\item{folder}{character, the folder where you store the downloaded files.
The working directory is the default folder.}

\item{progress}{logical, whether or not you want to see the progess via message.
Default to \code{FALSE}.}

\item{overwrite}{logical, whether or not you want to overwrite existing media files.
Default to \code{FALSE}.}

\item{n_retry}{integer, Number of time you should retry the failed request.
Default to 3L.}
}
\value{
Silently returns a vector of files paths.
}
\description{
Download submitted files associatted to a KoboToolbox API asset
}
\examples{
\dontrun{
kobo_setup()
uid <- "a9cwEQcbWqWzA5hzkjRUWi"
kobo_attachment_download(uid, folder = tempdir())
}

}
