% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_nest_for_modelling.R
\name{rmw_nest_for_modelling}
\alias{rmw_nest_for_modelling}
\title{Function to nest observational data before modelling with \strong{rmweather}.}
\usage{
rmw_nest_for_modelling(
  df,
  by = "resampled_set",
  n = 1,
  na.rm = FALSE,
  fraction = 0.8
)
}
\arguments{
\item{df}{Input data frame. Generally a time series of air quality data with 
pollutant concentrations and meteorological variables.}

\item{by}{Variables within \code{df} which will be used for nesting. 
Generally, \code{by} will be \code{"site"} and \code{"variable"}. 
\code{"resampled_set"} will always be added for clarity.}

\item{n}{Number of resampling sets to create.}

\item{na.rm}{Should missing values (NA) be removed from value?}

\item{fraction}{Fraction of the observations to make up the training set.}
}
\value{
Nested tibble.
}
\description{
\code{rmw_nest_for_modelling} will resample the observations if desired, will
test and prepare the data (with \code{\link{rmw_prepare_data}}), and return
a nested tibble ready for modelling.
}
\examples{

# Load package
library(dplyr)

# Keep things reproducible
set.seed(123)

# Prepare example data for modelling, replicate observations twice too
data_london \%>\% 
  rmw_nest_for_modelling(by = c("site", "variable"), n = 2)
 
}
\seealso{
\code{\link{rmw_prepare_data}}, \code{\link{rmw_model_nested_sets}}, 
\code{\link{rmw_predict_nested_sets}}
}
\author{
Stuart K. Grange
}
