% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_model_statistics.R
\name{rmw_model_statistics}
\alias{rmw_model_statistics}
\alias{rmw_model_importance}
\title{Functions to extract model statistics from a model calculated with
\code{rmw_calculate_model}.}
\usage{
rmw_model_statistics(model)

rmw_model_importance(model, date_unix = TRUE)
}
\arguments{
\item{model}{A ranger model object from \code{rmw_calculate_model}.}

\item{date_unix}{Should the \code{date_unix} variable be included in the 
return?}
}
\value{
Tibble.
}
\description{
Functions to extract model statistics from a model calculated with
\code{rmw_calculate_model}.
}
\details{
The variable importances are defined as "the permutation importance 
differences of predictions errors". This measure is unit-less and the values 
are not useful when comparing among data sets.
}
\examples{

# Extract statistics from the example random forest model
rmw_model_statistics(model_london)

# Extract importances from a model object
rmw_model_importance(model_london)

}
\author{
Stuart K. Grange
}
