% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riem_anova.R
\name{one_permutation}
\alias{one_permutation}
\title{Permutation Statistic for a Super Sample}
\usage{
one_permutation(x, stat_fun)
}
\arguments{
\item{x}{An object of class \code{CSuperSample},
representing the original super sample.}

\item{stat_fun}{A function to compute a statistic
on the resulting \code{CSuperSample} object.}
}
\value{
The value returned by \code{stat_fun} when applied
to the permuted super sample.
}
\description{
Randomly shuffles all observations across groups while preserving
group sample sizes, creating a new super sample under the null hypothesis
of no group differences, and computes a specified statistic on the
resulting permuted super sample.
}
\details{
This function performs a permutation test by:
\enumerate{
\item Extracting all data points from all groups
\item Randomly shuffling the data
\item Reassigning data to groups with the same sample sizes as the original
\item Computing the test statistic on the permuted data
}

This approach tests the null hypothesis that group labels are exchangeable,
which is natural for testing whether sub-populations differ.
}
