% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BlockchainRpcs.R
\name{pruneblockchain}
\alias{pruneblockchain}
\title{RPC-JSON API: pruneblockchain}
\usage{
pruneblockchain(con, height)
}
\arguments{
\item{con}{object of class \code{CONRPC}.}

\item{height}{\code{integer} The block height to prune up to.}
}
\value{
A S4-object of class \code{ANSRPC}.
}
\description{
Pruning of blockchain.
}
\section{Details}{

May be set to a discrete height, or a unix timestamp to prune blocks whose block time
is at least 2 hours older than the provided timestamp.
}

\references{
\url{https://bitcoin.org/en/developer-reference#pruneblockchain},
\url{https://bitcoin.org/en/developer-reference#remote-procedure-calls-rpcs}
}
\seealso{
Other Blockchain RPCs: 
\code{\link{decodescript}()},
\code{\link{getbestblockhash}()},
\code{\link{getblock}()},
\code{\link{getblockchaininfo}()},
\code{\link{getblockcount}()},
\code{\link{getblockhash}()},
\code{\link{getblockheader}()},
\code{\link{getchaintips}()},
\code{\link{getchaintxstats}()},
\code{\link{getdifficulty}()},
\code{\link{getmempoolancestors}()},
\code{\link{getmempooldescendants}()},
\code{\link{getmempoolentry}()},
\code{\link{getmempoolinfo}()},
\code{\link{getrawmempool}()},
\code{\link{gettxout}()},
\code{\link{gettxoutproof}()},
\code{\link{gettxoutsetinfo}()},
\code{\link{verifychain}()},
\code{\link{verifytxoutproof}()}
}
\author{
Bernhard Pfaff
}
\concept{Blockchain RPCs}
