% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double.R
\name{double_}
\alias{double_}
\alias{double_bounded}
\alias{double_left_bounded}
\alias{double_right_bounded}
\alias{double_positive}
\alias{double_negative}
\alias{double_fractional}
\alias{double_whole}
\title{Double generators}
\usage{
double_(
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_bounded(
  left,
  right,
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE
)

double_left_bounded(
  left,
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_right_bounded(
  right,
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_positive(
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_negative(
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_fractional(
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)

double_whole(
  len = c(1L, 10L),
  any_na = FALSE,
  any_nan = FALSE,
  any_inf = FALSE,
  big_dbl = FALSE
)
}
\arguments{
\item{len}{Length of the generated vectors. If \code{len} is a
single number all vectors will have this length. If
\code{len} is a numeric vector of length 2 it will produce
vectors with lengths between a minimum and maximum,
inclusive. For example \code{len = c(1L, 10L)} would produce
vectors with lengths between 1 and 10. To produce empty vectors
set \code{len = 0L} or a range like \code{len = c(0L, 10L)}.}

\item{any_na}{Whether \code{NA} values should be allowed.}

\item{any_nan}{Whether \code{NaN} values should be allowed.}

\item{any_inf}{Whether \code{Inf}/\code{-Inf} values should be allowed.}

\item{big_dbl}{Should doubles near the maximum size be
included? This may cause problems because if the result
of a computation results in a double larger than the
maximum it will return \code{Inf}.}

\item{left}{The minimum possible value for generated
numbers, inclusive.}

\item{right}{The maximum possible value for generated
numbers, inclusive.}
}
\value{
A \code{quickcheck_generator} object.
}
\description{
A set of generators for double vectors.
}
\examples{
double_() \%>\% show_example()
double_(big_dbl = TRUE) \%>\% show_example()
double_bounded(left = -5, right = 5) \%>\% show_example()
double_(len = 10L, any_na = TRUE) \%>\% show_example()
double_(len = 10L, any_nan = TRUE, any_inf = TRUE) \%>\% show_example()
}
