% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/or_plot.R
\name{plot_or}
\alias{plot_or}
\title{Plot Odds Ratios from Logistic Regression}
\usage{
plot_or(
  data,
  outcome,
  predictors,
  label_vjust = -0.8,
  label_hjust = 0.5,
  label_size = 3.5,
  label_color = "black",
  point_color = c("steelblue", "firebrick"),
  ref = TRUE
)
}
\arguments{
\item{data}{A data frame containing the outcome and predictors.}

\item{outcome}{Name of the binary outcome variable (as string).}

\item{predictors}{Vector of predictor variable names (as strings).}

\item{label_vjust}{Vertical adjustment for labels (default -0.8).}

\item{label_hjust}{Horizontal adjustment for labels (default 0.5).}

\item{label_size}{Size of the text labels (default 3.5).}

\item{label_color}{Color of the text labels (default "black").}

\item{point_color}{Colors for points corresponding to univariate and multivariate models (default c("steelblue", "firebrick")).}

\item{ref}{Logical, whether to show reference levels (default TRUE).}
}
\value{
A ggplot object showing odds ratios with confidence intervals.
}
\description{
This function fits univariate and multivariate logistic regression models
and plots odds ratios with 95\% confidence intervals. Reference levels can
optionally be displayed.
}
\examples{
# Load built-in infertility dataset
infert1 <- datasets::infert
infert$case <- factor(infert$case, levels = c(0,1), labels = c("Control","Infertile"))
infert$induced <- factor(infert$induced, levels = c(0,1), labels = c("No","Yes"))
infert$spontaneous <- factor(infert$spontaneous, levels = c(0,1), labels = c("No","Yes"))

# Plot with reference levels
plot_or(
  data = infert1,
  outcome = "case",
  predictors = c("parity","induced","spontaneous","age"),
  ref = TRUE
)

# Plot without reference levels
plot_or(
  data = infert1,
  outcome = "case",
  predictors = c("parity","induced","spontaneous","age"),
  ref = FALSE
)
}
