% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizationProblem-class.R
\name{optimizationProblem-class}
\alias{optimizationProblem-class}
\alias{OptimizationProblem}
\title{Optimization problem class}
\value{
No return value.
}
\description{
This class encodes the corresponding optimization model. It is created
using \code{problem()} function.
}
\section{Fields}{
 \describe{

\item{$data}{\code{list} object containing data
of the mathematical model.}

\item{$ConservationClass}{object of class
\code{\link[=data-class]{data-class()}} that contains the data input.}
}
}

\section{Methods}{
 \describe{
\item{getData(\code{character} name)}{
\code{\link[=vector]{vector()}}. Object stored in the \code{data} field with the
corresponding \code{name}. The data correspond to the different parts of
the mathematical model. The argument \code{name} can be made to the
following: "obj", "rhs", "sense", "vtype", "A", "bounds" or "modelsense".}

\item{getDataList()}{
\code{\link[=list]{list()}} of
\code{\link[=vector]{vector()}}. Object stored in the \code{data}. It contains all information relative
to the mathematical model, such as "obj", "rhs", etc.}

\item{print()}{
Print basic information of the optimization model.}

\item{show()}{
Call print method.}

}
}

\examples{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 1)

## Use class methods
head(problem_model$getData("obj"))

problem_model$print()
}
