% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSolutionBenefit.R
\name{getSolutionBenefit}
\alias{getSolutionBenefit}
\title{Extract benefit values}
\usage{
getSolutionBenefit(x, type = "total")
}
\arguments{
\item{x}{\code{Solution-class} or \code{Portfolio-class}.}

\item{type}{\code{character}. Output format of the benefits matrix; \code{total} shows
the total benefit by feature, while \code{local} format shows the benefit achieved per feature and planning unit.}
}
\value{
\link{data.frame}.
}
\description{
Returns the total benefit induced by the corresponding solution. The
total benefit is computed as the sum of the benefits obtained, for all features, across
all the units in the planning area.
}
\details{
For a given feature \eqn{s}, let \eqn{I_s} be the set of planning units associated with \eqn{s},
let \eqn{r_{is}} is the amount of feature \eqn{s} in planning unit \eqn{i}, let \eqn{K_{s}} be the
set of threats associated with \eqn{s}, and let \eqn{K_{i}} be the set of threats associated with \eqn{i}.
The local benefit associated with \eqn{s} in a unit \eqn{i} is given by:

\deqn{
b_{is} = p_{is} r_{is} \\
b_{is} = \frac{ \sum_{k \in K_i \cap K_s}{x_{ik}}}{|K_i \cap K_s|} r_{is}
}

Where \eqn{x_{ik}} is a decision variable such that \eqn{x_{ik} = 1} if an
action againts threat \eqn{k} is applied in unit \eqn{i}, and \eqn{x_{ik} = 0}, otherwise.
This expression for the probability of persistence of the feature (\eqn{p_{is}})
is defined only for the cases where we work with values of binary intensities
(presence or absence of threats). See the \href{https://prioriactions.github.io/prioriactions/articles/sensitivities.html}{sensitivities}
vignette to know the work with continuous intensities.

While the total benefit is calculated as the sum of the local benefits per feature:

\deqn{
b_{s} = \sum_{i \in I_{s}}\frac{ \sum_{k \in K_i \cap K_s}{x_{ik}}}{|K_i \cap K_s|} r_{is}
}
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Get maximum benefits to obtain
getPotentialBenefit(problem_data)

## Create optimization model
problem_model <- problem(x = problem_data)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 2, output_file = FALSE, cores = 2)

# get local benefits of solution
local_benefit <- getSolutionBenefit(s, type = "local")
head(local_benefit)

# get total benefits of solution
total_benefit <- getSolutionBenefit(s, type = "total")
head(total_benefit)
}

}
