% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{BTmatrix}
\alias{BTmatrix}
\title{Back-transform matrix of parameter values}
\usage{
BTmatrix(transformed, limits)
}
\arguments{
\item{transformed}{a matrix of transformed parameter values. Each column
should be a different parameter and each row a different simulation. This
is the matrix that you wish to back-transform so that the parameter values
are all in the original scale.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}
}
\value{
a matrix with the same dimensions as the \code{transformed} matrix
but with the parameter values back-transformed.
}
\description{
This function applies a back-transformation to the parameter values.
}
\details{
The back-transformation should be applied after parameter estimation using an
Approximate Bayesian Computation framework. It will return the parameter
values back to their original scale.
}
\keyword{internal}
