% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphtest-functions.R
\name{plot_permutations}
\alias{plot_permutations}
\title{Plots the permutation distribution}
\usage{
plot_permutations(graphtest, bins = 30)
}
\arguments{
\item{graphtest}{The output from graph_perm_test.}

\item{bins}{The number of bins to use for the histogram.}
}
\value{
A ggplot object.
}
\description{
Plots a histogram of the permutation distribution of the number of
pure edges and a mark showing the observed number of pure edges.
}
\examples{
library(phyloseq)
data(enterotype)
gt = graph_perm_test(enterotype, sampletype = "SeqTech")
plot_permutations(gt)
}
