% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{neg_log_lik}
\alias{neg_log_lik}
\title{Negative Log-Likelihood function}
\usage{
neg_log_lik(theta, Rvect, n, pi0, alpha, beta, alpha0, ...)
}
\arguments{
\item{theta}{A \code{numeric} value for the paramerer of interest.}

\item{Rvect}{A \code{vector} of observations, i.e. (R1, R2, R3, R4).}

\item{n}{A \code{numeric} that provides the sample size.}

\item{pi0}{A \code{numeric} that provides the prevalence or proportion of people (in the whole population) who are positive, as measured through a non-random,
but systematic sampling (e.g. based on medical selection).}

\item{alpha}{A \code{numeric} that provides the False Negative (FN) rate for the sample R.}

\item{beta}{A \code{numeric} that provides the False Positive (FP) rate for the sample R.}

\item{alpha0}{A \code{numeric} that corresponds to the probability that a random participant
has been incorrectly declared positive through the nontransparent procedure. In most applications,
this probability is likely very close to zero.}

\item{...}{Additional arguments.}
}
\value{
Negative log-likelihood.
}
\description{
Log-Likelihood function based on R1, R2, R3 and R4 multiplied by -1.
}
\author{
Stephane Guerrier
}
\keyword{internal}
