% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_models.R
\name{get_model_env}
\alias{get_model_env}
\alias{get_from_env}
\alias{set_in_env}
\alias{set_env_val}
\title{Working with the parsnip model environment}
\usage{
get_model_env()

get_from_env(items)

set_in_env(...)

set_env_val(name, value)
}
\arguments{
\item{items}{A character string of objects in the model environment.}

\item{...}{Named values that will be assigned to the model environment.}

\item{name}{A single character value for a new symbol in the model environment.}

\item{value}{A single value for a new value in the model environment.}
}
\description{
These functions read and write to the environment where the package stores
information about model specifications.
}
\examples{
\dontshow{if (!parsnip:::is_cran_check()) withAutoprint(\{ # examplesIf}
# Access the model data:
current_code <- get_model_env()
ls(envir = current_code)
\dontshow{\}) # examplesIf}
}
\references{
"How to build a parsnip model"
\url{https://www.tidymodels.org/learn/develop/models/}
}
\keyword{internal}
