% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conference_stats.R
\name{conference_stats}
\alias{conference_stats}
\title{Aggregate player statistics for a NCAA conference and seasons}
\usage{
conference_stats(
  year = NULL,
  conf = NULL,
  level = NULL,
  sport = "WVB",
  save = FALSE,
  path = "."
)
}
\arguments{
\item{year}{Numeric vector of years for fall of desired seasons.}

\item{conf}{NCAA conference name.}

\item{level}{Character string defining whether to aggregate "teamseason",
"teammatch", "playermatch", or match play-by-play ("pbp") data.}

\item{sport}{Three letter abbreviation for NCAA sport (must be upper case;
for example "WVB" for women's volleyball and "MVB" for men's volleyball).}

\item{save}{Logical for whether to save the statistics locally as CSVs
(default FALSE).}

\item{path}{Character string of path to save statistics files.}
}
\value{
For season level, returns list with data frames of player statistics and
team statistics. For match and pbp levels, returns data frame of player
statistics and play-by-play information respectively.
}
\description{
This is a wrapper around \code{\link[=group_stats]{group_stats()}} that extracts season, match, or pbp
data from players in all teams in the chosen conference. For season stats,
it aggregates all player data and team data into separate data frames and
combines them into a list. For match and pbp stats, it aggregates into a
data frame.
Conferences names can be found in
\link{ncaa_conferences}.
}
\note{
This function \strong{requires internet connectivity} as it checks the
\href{https://stats.ncaa.org}{NCAA website} for information.
It also uses the \href{https://rstudio.github.io/chromote/}{\code{{chromote}}} package
and \strong{requires \href{https://www.google.com/chrome/}{Google Chrome}} to be
installed.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
conference_stats(year = 2024, conf = "Peach Belt", level = "teamseason")
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions that aggregate statistics: 
\code{\link{division_stats}()},
\code{\link{group_stats}()}
}
\concept{functions that aggregate statistics}
