% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchGrowth.R
\name{matchGrowth}
\alias{matchGrowth}
\title{Adjust model to produce observed growth}
\usage{
matchGrowth(params, species = NULL, keep = c("egg", "biomass", "number"))
}
\arguments{
\item{params}{A MizerParams object}

\item{species}{The species to be affected. Optional. By default all species
for which growth information is available will be affected. A vector of
species names, or a numeric vector with the species indices, or a logical
vector indicating for each species whether it is to be affected (TRUE) or
not.}

\item{keep}{A string determining which quantity is to be kept constant. The
choices are "egg" which keeps the egg density constant, "biomass" which
keeps the total biomass of the species constant and "number" which keeps
the total number of individuals constant.}
}
\value{
A modified MizerParams object with rescaled search volume, maximum
consumption rate and metabolic rate and rescaled species parameters
\code{gamma},\code{h}, \code{ks} and \code{k}.
}
\description{
Scales the search volume, the maximum consumption rate, the metabolic rate
and the external encounter rate
all by the same factor in order to achieve a growth rate that allows
individuals to reach their maturity size by their maturity age while keeping
the feeding level and the critical feeding level unchanged. Then recalculates
the size spectra using \code{\link[=steadySingleSpecies]{steadySingleSpecies()}}.
}
\details{
Maturity size and age are taken from the \code{w_mat} and \code{age_mat} columns in the
species_params data frame. If \code{age_mat} is missing, mizer calculates it from
the von Bertalanffy growth curve parameters using \code{age_mat_vB()}. If those
are not available either for a species, the growth rate for that species will
not be changed.
}
